import { Routes } from '@angular/router';
import { HomeComponent } from './home/home.component';
import { UsersComponent } from './users/users.component';
import { ProductsComponent } from './products/products.component';
import { UserComponent } from './users/user/user.component';
import { EditproductComponent } from './products/editproduct/editproduct.component';
import { ProductComponent } from './products/product/product.component';
import { AuthguardService } from './authguard.service';

export const routes: Routes = [


  //http://localhost:4200/customers ==> UsersComponent will be bootstrapped
   //http://localhost:4200/customer/1/Ramu
      //http://localhost:4200/customer/2/Sita 

    {path:'',component:HomeComponent} ,
    //http://localhost:4200 ==> Home Component

   /* 
   {path:'customers',component:UsersComponent} ,
    {path:'customers/:id/:name',component:UserComponent},
    
    */


    // Child Routing

    {path:'customers',component:UsersComponent,canActivate:[AuthguardService],
      children:[
          {path:':id/:name',component:UserComponent}
      ]

    },
   

    {path:'products',component:ProductsComponent,canActivate:[AuthguardService],
      children:[
        {path:':id',component:ProductComponent},
        {path:':id/edit',component:EditproductComponent},
      ]
    } ,
    //http://localhost:4200/products ==> ProductComponent will be bootstrapped
    //http://localhost:4200/products/1 ==>Product Component with id 1 will be launched
     //http://localhost:4200/products/1/edit ==> Edit Product Component will be lanunched with 1
];
