import { Injectable } from '@angular/core';
import { ActivatedRouteSnapshot, CanActivate, GuardResult, MaybeAsync, Router, RouterStateSnapshot } from '@angular/router';
import { AuthserviceService } from './authservice.service';

@Injectable({
  providedIn: 'root'
})
export class AuthguardService implements CanActivate {

  constructor(private router:Router,private authService:AuthserviceService) { }
  canActivate(route: ActivatedRouteSnapshot, 
    state: RouterStateSnapshot): MaybeAsync<GuardResult> {

      //We need to write back end logic
      return this.authService.verifyRedirection().then(

          (allowRedirect:any)=>{

            if(allowRedirect){
              console.log("Guard Return True Value and Hence Redirection");
              return true;
            }
            else
            {
              console.log("Guard Returns False Value and hence not redirecting");
              this.router.navigate(['/']);
              return false;
            }

          }

      )
    
  }
}
