import { Component } from '@angular/core';
import { ProductService } from '../../product.service';
import { FormsModule } from '@angular/forms';
import { CommonModule } from '@angular/common';
import { ActivatedRoute, Params, Router } from '@angular/router';

@Component({
  selector: 'app-editproduct',
  standalone: true,
  imports: [FormsModule,CommonModule],
  templateUrl: './editproduct.component.html',
  styleUrl: './editproduct.component.css'
})
export class EditproductComponent {


   //server?: {id: number, name: string, status: string};
   product:any={};
   productName = '';
   productStatus = '';
   allowEdit:boolean=false;
 
   constructor(private prdService: ProductService,
    private router:Router,private actRoute:ActivatedRoute) { }
 
   ngOnInit() {
    const prodId=+this.actRoute.snapshot.params['id'];
     this.product = this.prdService.getProduct(prodId);

     this.productName = this.product.name;
     this.productStatus = this.product.status;

     this.actRoute.queryParams.subscribe(
      (queryParams:Params)=>{
        this.allowEdit=queryParams['allowEdit']=='1'?true:false
      }
     )
   }
 
   onUpdateProduct() {
     this.prdService.updateProduct(this.product.id, {name: this.productName, status: this.productStatus});
   }

}
