import { Component } from '@angular/core';
import { ProductService } from '../../product.service';
import { FormsModule } from '@angular/forms';
import { CommonModule } from '@angular/common';
import { ActivatedRoute, Params, Router } from '@angular/router';

@Component({
  selector: 'app-product',
  standalone: true,
  imports: [FormsModule,CommonModule],
  templateUrl: './product.component.html',
  styleUrl: './product.component.css'
})
export class ProductComponent {


  product:any={};

  constructor(private prdService: ProductService,
    private router:Router,private actRoute:ActivatedRoute
  ) { }

  ngOnInit() {
    //http://localhost:4200/products/1
     //http://localhost:4200/products/2
    const prodId=+this.actRoute.snapshot.params['id'];
    this.product = this.prdService.getProduct(prodId);

    this.actRoute.params.subscribe(
      (params:Params)=>{
        this.product = this.prdService.getProduct(+params['id']);
      }
    )
  }

  onEdit(){
     //http://localhost:4200/products/1/edit
    this.router.navigate(['edit'],{relativeTo:this.actRoute,queryParamsHandling:'preserve'});
  }
}
