import { Component } from '@angular/core';
import { ActivatedRoute, Params, RouterModule } from '@angular/router';

@Component({
  selector: 'app-user',
  standalone: true,
  imports: [RouterModule],
  templateUrl: './user.component.html',
  styleUrl: './user.component.css'
})
export class UserComponent {
 // user?: {id: number, name: string};
 user:any={};

  constructor(private route:ActivatedRoute) { }

  ngOnInit() {
    this.user={
      id:this.route.snapshot.params['id'],
      name:this.route.snapshot.params['name']
    }

    this.route.params.subscribe(
        (params:Params)=>{
         this.user.id =params['id'],
         this.user.name =params['name']

        }

    )
  }
}
