
from django.db import models
from django.urls import reverse

class Employee(models.Model):
    ename = models.CharField(max_length=30,db_column="empname")
    salary = models.IntegerField()
    city = models.CharField(max_length=30)
    email = models.EmailField(blank=True, null=True)

    def __str__(self):
        return self.ename

    class Meta:
        db_table = "employee"

    def get_absolute_url(self):
        return reverse("employee-list")