
from django.shortcuts import render
from employeeapp.models import Employee

from django.views.generic import (
    ListView, DetailView, CreateView, UpdateView, DeleteView
)

class EmployeeListView(ListView):
    model = Employee
    context_object_name = 'employee_list'
    template_name = 'employeeapp/employee_list.html'


class EmployeeCreateView(CreateView):
    model = Employee
    fields = '__all__'
    context_object_name = 'form'
    template_name = 'employeeapp/employee_form.html'

class EmployeeUpdateView(UpdateView):
    model = Employee
    fields = '__all__'
    context_object_name = 'form'
    template_name = 'employeeapp/employee_form.html'

class EmployeeDeleteView(DeleteView):
    model = Employee
    success_url = '/employee/list/'
    context_object_name = 'employee'
    template_name = 'employeeapp/employee_confirm_delete.html'




### using function logics
'''
def EmployeeListView(request):
    context = {
        "employee_list": Employee.objects.all()
    }
    return render(request, "employeeapp/employee_list.html", context)
'''
