
from django.shortcuts import render, redirect
from employeeapp.models import Employee
from employeeapp.forms import EmployeeModelForm

def CreateEmployeeView(request):
    if request.method == 'POST':
        form = EmployeeModelForm(request.POST, request.FILES)
        if form.is_valid():
            form.save()
            context = {
                "success" : "Employee Data Created Successfully"
            }
            return render(request, 'employeeapp/employee_create.html', context)
        else:
            context = {
                "error" : "Employee Data Not created into database table"
            }
            return render(request, 'employeeapp/employee_create.html', context)

    else:
        form = EmployeeModelForm()
        context  = {
            'form': form
        }
        return render(request, 'employeeapp/employee_create.html', context)


def EmployeeListView(request):
    employee_list = Employee.objects.all()
    context = {
        'employee_list' : employee_list
    }
    return render(request, 'employeeapp/employee_list.html', context)



