"""
URL configuration for UserAuthentication project.

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/5.2/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""
from django.contrib import admin
from django.urls import path

from accounts import views as accounts_views
from django.contrib.auth import views as auth_views

urlpatterns = [
    path('admin/', admin.site.urls),

    path('home/', accounts_views.home_view, name="home-page"),

    path('contact/', accounts_views.contact_view, name="contact-page"),

    path('login/', auth_views.LoginView.as_view(
        template_name='accounts/login.html'), name="login-page"),

    path('logout/', accounts_views.logout_view, name="logout-page"),
]
