

### developing APIs using APIView Concept  ####
'''
from django.shortcuts import render

from employeesapp.models import Employee
from employeesapp.api.serializers import EmployeeModelSerializer

from rest_framework.response import Response # dict ---> json ---->> browser/app2
from rest_framework import status
from rest_framework.views import APIView

class EmployeeListView(APIView):
    def get(self, request): # db ---> orm ---> queryset ---> dict ---> json ---> browser/app2
        employee_list = Employee.objects.all() # <QuerySet [{..},{..},..]> | <QuerySet []>

        serializer = EmployeeModelSerializer(employee_list, many=True)

        return Response(serializer.data, status=status.HTTP_200_OK)

    def post(self, request): # browser/app2 ---> json --->> dict ---> queryset ---> orm ---> db
        serializer = EmployeeModelSerializer(data=request.data)
        if serializer.is_valid():
            serializer.save()
            return Response(serializer.data, status=status.HTTP_201_CREATED)
        else:
            return Response(serializer.errors, status=status.HTTP_400_BAD_REQUEST)

class EmployeeDetailView(APIView):
    def get(self,request,pk): #  db ---> orm ---> queryset ---> dict ---> json ---> browser/app2
        try:
            employee = Employee.objects.get(id=pk)
        except Employee.DoesNotExist:
            context = {
                "message" : "Employee with that id does not exist for display"
            }
            return Response(context,  status=status.HTTP_404_NOT_FOUND)
        else:
            serializer = EmployeeModelSerializer(employee)
            return Response(serializer.data, status=status.HTTP_200_OK)


    def put(self,request,pk):
        try:
            employee = Employee.objects.get(id=pk)
        except Employee.DoesNotExist:
            context = {
                "message" : "Employee with that id does not exist for update"
            }
            return Response(context,  status=status.HTTP_404_NOT_FOUND)
        else:
            serializer = EmployeeModelSerializer(employee, data=request.data)
            if serializer.is_valid():
                serializer.save()
                return Response(serializer.data, status=status.HTTP_200_OK)
            else:
                return Response(serializer.errors, status=status.HTTP_400_BAD_REQUEST)


    def delete(self,request,pk):
        try:
            employee = Employee.objects.get(id=pk)
        except Employee.DoesNotExist:
            context = {
                "message" : "Employee with that id does not exist for delete"
            }
            return Response(context,  status=status.HTTP_404_NOT_FOUND)
        else:
            employee.delete()
            context = {
                "message" : "Employee with that id deleted successfully!"
            }
            return Response(context, status=status.HTTP_204_NO_CONTENT)

'''

#### developing APIs using mixins module Concept  ###
'''
from employeesapp.models import Employee
from employeesapp.api.serializers import EmployeeModelSerializer

from rest_framework import mixins, generics

class EmployeeListView(mixins.ListModelMixin, mixins.CreateModelMixin, generics.GenericAPIView):
    queryset = Employee.objects.all()
    serializer_class = EmployeeModelSerializer

    def get(self,request):
        return self.list(request)

    def post(self,request):
        return self.create(request)


class EmployeeDetailView(mixins.RetrieveModelMixin, mixins.UpdateModelMixin, mixins.DestroyModelMixin,
                         generics.GenericAPIView):
    queryset = Employee.objects.all()
    serializer_class = EmployeeModelSerializer

    def get(self, request,pk):
        return self.retrieve(request, pk)

    def put(self, request,pk):
        return self.update(request, pk)

    def delete(self, request,pk):
        return self.destroy(request, pk)

'''


### developing APIs using  "generics" module Concept  ###
'''
from employeesapp.models import Employee
from employeesapp.api.serializers import EmployeeModelSerializer

from rest_framework import  generics

class EmployeeListView(generics.ListCreateAPIView):
    queryset = Employee.objects.all()
    serializer_class = EmployeeModelSerializer

class EmployeeDetailView(generics.RetrieveUpdateDestroyAPIView):
    queryset = Employee.objects.all()
    serializer_class = EmployeeModelSerializer

'''


#### developing APIs using "viewsets" module Concept ####

from employeesapp.models import Employee
from employeesapp.api.serializers import EmployeeModelSerializer

from rest_framework import  viewsets

class EmployeeView(viewsets.ModelViewSet):
    queryset = Employee.objects.all()
    serializer_class = EmployeeModelSerializer

























