package com.springboot.stock.model;

import javax.persistence.*;

@Entity
@Table(name = "quotes")
public class Quote {

	@Id
	@GeneratedValue(strategy = GenerationType.AUTO)
	@Column(name = "id")
	private Integer id;

	@Column(name = "user_name")
	private String userName;

	@Column(name = "quote")
	private String quote;
	
	
	/*
	 * input JSON :
	 * {
	 * userid:'vijay',
	 * qutoes:'AIRTEL,RELIANCE,JIO,VODAFONE'
	 * }
	 * 
	 * 
	 * 	input JSON :
	 * {
	 * userid:'sandhya',
	 * qutoes:'SBI,PNB,ICICI,HDFC'
	 * }

	 */
	
	
	/*
	 * 1 vijay RELIANCE
	 * 2 VIJAY AIRTEL
	 * 3 VIJAY JIO
	 * 4 VIJAY VODAFONE
	 * 
	 * 5 SANDHYA SBI
	 * 6 SANDHYA PNB
	 * 7 SANDHYA ICICI
	 * 8 SANDHYA HDFC
	 */

	public Quote() {
	}

	public Quote(String userName, String quote) {
		this.userName = userName;
		this.quote = quote;
	}

	public Integer getId() {
		return id;
	}

	public void setId(Integer id) {
		this.id = id;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getQuote() {
		return quote;
	}

	public void setQuote(String quote) {
		this.quote = quote;
	}
}
