package com.springboot.stock.resource;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.springboot.stock.model.Quote;
import com.springboot.stock.model.Quotes;
import com.springboot.stock.repository.QuotesRepository;


@RestController
@RequestMapping("/rest/db")
//http://localhost:8300/rest/db/vijay
public class DbServiceResource {

	Logger logger= LoggerFactory.getLogger(DbServiceResource.class);
	
	@Autowired
	private QuotesRepository quotesRepository;

	@GetMapping("/{username}")
	public List<String> getQuotes(@PathVariable("username") final String username) {
		 logger.info("DbServiceResource  getQuotes : "+username);

		return getQuotesByUserName(username);

	}
	private List<String> getQuotesByUserName(@PathVariable("username") String username){
		
		/*
		 * quotesRepository.findByUserName ==> select * from quotes where username='VIJAY';
		 * 
		 *  1 vijay RELIANCE
			2 vijay hdfc
			3 vijay JIO
			4 vijay VODAFONE
		
		 *  RELIANCE,HDFC,JIO,VODAFONE
		 */
		return quotesRepository.findByUserName(username).
				stream().map( //1 vijay RELIANCE 
							  //2 vijay hdfc
						quote -> {
										return quote.getQuote();
									   }
						).collect(Collectors.toList()); //RELIANCE,HDFC,JIO,VODAFONE
	}

	@PostMapping("/add")
	public List<String> add(@RequestBody final Quotes quotes) {
		
		/*
		Quotes qutoes=new Quotes();
		
		INput
		List<String> quoteslist=new ArrayList<>();
		quoteslist.add("reliance");
		quoteslist.add("HDFC");
		qutoes.setUserName("vijay");
		qutoes.setQuotes(quoteslist);
		return qutoes;
		
		 input JSON :
	  {
	  userid:'vijay',
	  qutoes:'AIRTEL,RELIANCE,JIO,VODAFONE'
	  }
		
		DB Part
		1 vijay RELIANCE
		2 vijay hdfc
		3 vijay JIO
		4 vijay VODAFONE
		
		Output
		RELIANCE,HDFC,JIO,VODAFONE
		*/
		
		
		
		quotes.getQuotes().stream()
		.map(	//AIRTEL,RELIANCE,JIO,VODAFONE
				quote -> new Quote(quotes.getUserName(), quote))
				//VIJAY,AIRTEL
				//VIJAY,RELIANCE,
				//VIJAY,JIO
				//VIJAY,VODAFONE
				.forEach(quote -> {
					quotesRepository.save(quote);
				}
				);
		return getQuotesByUserName(quotes.getUserName()); 
		//return getQuotesByUserName(quotes.getUserName());
	}
	
	
	

	
    @PostMapping("/delete/{username}")
    public List<String> delete(@PathVariable("username") final String username) {

        List<Quote> quotes = quotesRepository.findByUserName(username);
        quotesRepository.deleteAll(quotes);

        return getQuotesByUserName(username);
    }
    

}
