package com.ashokit.advjpa;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

import com.ashokit.advjpa.model.CustomType;
import com.ashokit.advjpa.model.Employee;
import com.ashokit.advjpa.model.Person;
import com.ashokit.advjpa.service.PersonService;

@SpringBootApplication
public class AdvDataJpaApplication implements CommandLineRunner{
	
	
	@Autowired
	private PersonService personService;

	public static void main(String[] args) {
		SpringApplication.run(AdvDataJpaApplication.class, args);
	}

	@Override
	public void run(String... args) throws Exception {
		
		//createPersons();
		//getPersonByIds();
		//findByLastNameAndFirstName();
		//findByLastNameOrFirstName();
		//findByLastNameOrderByCreatedDateDesc();
		//findByAgeLessThanEqual();
	//	findByFirstNameLike();
	//	findByLastNameAndAgeLessThanEqual();
		//findByCreatedDateBetweenwithTime();
		//searchpersonbyLastname();
		
		//createEmployees();
		//findMaxSalariesbyDept();
		//giveFewColumns();
		findPersonInfobyFirstNameorEmail();
		findPersonINfobyFirstname();
		
	}
	
	
	
	
	private void findPersonInfobyFirstNameorEmail() {
		Iterable<Person> personsList = personService.findPersonInfobyFirstNameorEmail( "Sita","lakshman@gmail.com");

		for (Person person : personsList) {
			System.out.println("Person Object" + person.toString());

		}

	}
	
	private void findPersonINfobyFirstname() {
		Iterable<Person> personsList = personService.findPersonINfobyFirstname( "Sita");

		for (Person person : personsList) {
			System.out.println("Person Object" + person.toString());

		}

	}
	
	
	private void giveFewColumns() {
		Iterable<CustomType> personsList = personService.giveFewColumns("kumar");

		for (CustomType person : personsList) {
			System.out.println("Person Object" + person.toString());

		}

	}
	
	
	private void findMaxSalariesbyDept() {
		System.out.println(" -- finding max salaries in Admin and IT depts  --");
		List<Object[]> list = personService.findMaxSalariesByDept(Arrays.asList("Admin", "IT","HR"));
		list.forEach(arr -> {
			System.out.println(Arrays.toString(arr));
		});
	}
	
	
	private void createEmployees() {
		
		List<Employee> empList = Arrays.asList(
				Employee.create("Ram", "Admin", 20000),
				Employee.create("Gopi", "Admin", 35000),

				Employee.create("Sita", "Sale", 10000),
				Employee.create("Ganesh", "Sale", 30000),

				Employee.create("Laxman", "IT", 40000), 
				Employee.create("Seenu", "IT", 25000),
				
				Employee.create("Swathi", "HR", 80000), 
				Employee.create("Sneha", "HR", 65000)
				
				
				);

		Iterable<Employee> list = personService.saveAllEmployees(empList);
		for (Employee emp : list) {
			System.out.println("Employee Object" + emp.toString());

		}
	}
	


	
	private void searchpersonbyLastname() {
		Iterable<Person> personsList = personService.searchpersonbyLastname( "kumar");

		for (Person person : personsList) {
			System.out.println("Person Object" + person.toString());

		}

	}
	
	
	
	private void findByLastNameAndFirstName() {
		//Person person = personService.findByFirstNameAndLastName("Ram", "kumar");
		Person person=personService.findByLastNameAndFirstName("kumar", "Ram");
		System.out.println("Person Object" + person.toString());

	}
	
	
	private void findByLastNameOrFirstName() {
		Iterable<Person> personsList = personService.findByLastNameOrFirstName( "kumar","Sita");

		for (Person person : personsList) {
			System.out.println("Person Object" + person.toString());

		}

	}
	
	private void findByLastNameOrderByCreatedDateDesc() {
		Iterable<Person> personsList = personService.findByLastNameOrderByCreatedDateDesc("kumar");

		for (Person person : personsList) {
			System.out.println("Person Object" + person.toString());

		}

	}
	
	
	
	
	
	
	private void findByAgeLessThanEqual() {
		Iterable<Person> personsList = personService.findByAgeLessThanEqual(40);

		for (Person person : personsList) {
			System.out.println("Person Object" + person.toString());

		}

	}
	
	
	
	
	
	private void findByFirstNameLike() {
		Iterable<Person> personsList = personService.findByFirstNameLike("%Kiran%");

		for (Person person : personsList) {
			System.out.println("Person Object" + person.toString());

		}

	}
	
	
	private void findByLastNameAndAgeLessThanEqual() {
		Iterable<Person> personsList = personService.findByLastNameAndAgeLessThanEqual("kumar",40);

		for (Person person : personsList) {
			System.out.println("Person Object" + person.toString());

		}

	}
	
	
	private void findByCreatedDateBetweenwithTime() {
		//2024-05-26 06:29:34.373
		Iterable<Person> personsList = personService.findByCreatedDateBetween(
				getDatewithTime("2024-10-23 07:08:00"), 
				getDatewithTime("2024-10-24 07:08:03"));

		for (Person person : personsList) {
			System.out.println("Person Object" + person.toString());

		}

	}
	
	private Date getDatewithTime(String dateString) {
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

		try {
			return format.parse(dateString);
		} catch (ParseException pe) {
			throw new RuntimeException(pe);
		}
	}
	
	
	
	private void createPersons() {

		/*
		 * List<Person> personList=new ArrayList<Person>();
		 * 
		 * personList.add(new Person("Kiran", "kumar", "kiran@gmail.com", 20));
		 * 
		 * personList.add(new Person("Kiran", "kumar", "kiran@gmail.com", 20));
		 * 
		 * personList.add(new Person("Kiran", "kumar", "kiran@gmail.com", 20));
		 * personList.add(new Person("Kiran", "kumar", "kiran@gmail.com", 20));
		 * personList.add(new Person("Kiran", "kumar", "kiran@gmail.com", 20));
		 * personList.add(new Person("Kiran", "kumar", "kiran@gmail.com", 20));
		 * personList.add(new Person("Kiran", "kumar", "kiran@gmail.com", 20));
		 * personList.add(new Person("Kiran", "kumar", "kiran@gmail.com", 20));
		 */

		List<Person> personList = Arrays.asList(
				new Person("Kiran", "kumar", "kiran@gmail.com", 20),
				new Person("Ram", "kumar", "ram@gmail.com", 22),
				new Person("RamKiran", "LaxmiKiran", "sita@gmail.com", 30),
				new Person("Lakshamn", "Seth", "seth@gmail.com", 50),
				new Person("Sita", "Kumar", "lakshman@gmail.com", 50),
				new Person("Ganesh", "Kumar", "ganesh@gmail.com", 50),
				new Person("KiranKiran", "kumar", "kirannew@gmail.com", 20),
				new Person("RamRam", "kumar", "ramnew@gmail.com", 22),
				new Person("RamKiranRamKiran", "LaxmiKiran", "sitanew@gmail.com", 30),
				new Person("RamKiranRamKiran", "Seth", "sethnee@gmail.com", 50),
				new Person("SitaSita", "Kumar", "lakshmannew@gmail.com", 50),
				new Person("GaneshSita", "Kumar", "ganeshnew@gmail.com", 50));

		Iterable<Person> list = personService.saveAllPersons(personList);
		for (Person person : list) {
			System.out.println("Person Object" + person.toString());

		}
	}
	
	
	private void getPersonByIds() {
		List<Integer> personList = new ArrayList<Integer>();
		personList.add(1);
		personList.add(2);
		personList.add(12);
		personList.add(5);
		personList.add(6);
		personList.add(20);
		personList.add(40);
		personList.add(11);
		personList.add(15);
		personList.add(3);
		personList.add(4);
		Iterable<Person> personsList = personService.getPersonsData(personList);
		//select * from tbl_person where person_id in (1,2,12,5,6,20,40,11,15,3,4);
		for (Person person : personsList) {
			System.out.println("Person Object" + person.toString());

		}
	}
}
