package com.ashokit.advjpa.dao;

import java.util.Date;
import java.util.List;

import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.stereotype.Repository;

import com.ashokit.advjpa.model.CustomType;
import com.ashokit.advjpa.model.Person;

@Repository
public interface PersonDao extends CrudRepository<Person, Integer> {
	
	//Advanced Keywords in Derived Query
	
	public Person findByLastNameAndFirstName(String lastName,String firstName);
	//select * from tbl_person where last_name=lastName and first_name=firstName
	//Output ==> Single Entity
	
	
	public Iterable<Person> findByLastNameOrFirstName(String lastName,String firstName);
	//select * from tbl_person where last_name=lastName or first_name=firstName
	//Output ==> Collection(More than One Entity)
	
	
	public List<Person> findByLastNameOrderByCreatedDateDesc(String lastName);
	//select * from tbl_person where last_name=lastName order by created_date desc;
	
	
	public List<Person> findByAgeLessThanEqual(Integer age);
	//select * from tbl_person where age<=age;
	
	
	public List<Person> findByFirstNameLike(String firstName);
	//select * from tbl_person where first_name like '%Ram%'
	
	
	public List<Person> findByLastNameAndAgeLessThanEqual(String lastName,int age);
	//select * from tbl_person where last_name=lastName and age<=age

	
	
	public List<Person> findByCreatedDateBetween(Date startdate,Date endDate);
	//select * from tbl_person where created_date>=startdate and created_date<=enddate
	
	
	//NamedQuery Example ==> Abstract Method at Interface Layer
	public List<Person> searchpersonbyLastname(String lastName);

	
	public List<CustomType> giveFewColumns(String lastName);
	
	
	//Query and Native Query ==> Both Abstract Method and Implementation at Model Layer
	
	//As part of Query and Native Query both Abstract Method and Implementation at Interface Layer itself
	@Query(value="SELECT p FROM Person p where p.firstName=?1 OR p.email=?2")    //Implementation
	List<Person> findPersonInfobyFirstNameorEmail(String firstName,String email); //Abstract Method
	
	
	@Query(value="SELECT * FROM tbl_person p where p.first_name=?1",nativeQuery = true) //Implementation
	List<Person> findPersonINfobyFirstname(String firstName);							//Abstract Method
		
	
	
}
