package com.ashokit.advjpa.service;

import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ashokit.advjpa.dao.EmployeeDao;
import com.ashokit.advjpa.dao.PersonDao;
import com.ashokit.advjpa.model.CustomType;
import com.ashokit.advjpa.model.Employee;
import com.ashokit.advjpa.model.Person;

@Service
public class PersonService {
	
	
	@Autowired
	private PersonDao personDao;
	
	
	@Autowired
	private EmployeeDao empDao;
	
	
	
	public List<Person> findPersonInfobyFirstNameorEmail(String firstName,String email){
		return personDao.findPersonInfobyFirstNameorEmail(firstName, email);
	}
	
	public List<Person> findPersonINfobyFirstname(String firstName){
		return personDao.findPersonINfobyFirstname(firstName);
	}
	
	
	public List<CustomType> giveFewColumns(String lastName){
		return personDao.giveFewColumns(lastName);
	}
	
	
	//SaveAll Employess
	public Iterable<Employee> saveAllEmployees(Iterable<Employee> empList){
		return empDao.saveAll(empList);
	}
	
	
	public Iterable<Employee> getAllEmployees(){
		return empDao.findAll();
	}
	
	public List<Object[]> findMaxSalariesByDept(List<String> deptNames){
		return empDao.findMaxSalariesByDept(deptNames);
	}
	//GetAll Employees
	
	
	//SaveAll Implementation
	
	public Iterable<Person> saveAllPersons(Iterable<Person> personsList){
		return personDao.saveAll(personsList);
		
		/*
		 * saveAll ==> Iterate Through each and every object and insert every record
		 */
	}
	
	
	
	
	//FindAllById Implementation

	public Iterable<Person> getPersonsData(List<Integer> personIds){
		return personDao.findAllById(personIds);
	}
	
	public List<Person> findByFirstNameLike(String firstName){
		return personDao.findByFirstNameLike(firstName);
	}
	
	public List<Person> findByLastNameAndAgeLessThanEqual(String lastName,int age){
		return personDao.findByLastNameAndAgeLessThanEqual(lastName, age);
	}
	
	public List<Person> findByAgeLessThanEqual(Integer age){
		return personDao.findByAgeLessThanEqual(age);
	}
	
	public List<Person> findByCreatedDateBetween(Date startdate,Date endDate){
		return personDao.findByCreatedDateBetween(startdate, endDate);
	}
	
	
	
	public Person findByLastNameAndFirstName(String lastName,String firstName) {
		return personDao.findByLastNameAndFirstName(lastName, firstName);
	}
	
	
	public Iterable<Person> findByLastNameOrFirstName(String lastName,String firstName){
		return personDao.findByLastNameOrFirstName(lastName, firstName);
	}
	
	public List<Person> findByLastNameOrderByCreatedDateDesc(String lastName){
		return personDao.findByLastNameOrderByCreatedDateDesc(lastName);
	}
	
	public List<Person> searchpersonbyLastname(String lastName){
		return personDao.searchpersonbyLastname(lastName);
	}
}
