package com.ashokit.ticketbooking.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.ashokit.ticketbooking.model.Ticket;
import com.ashokit.ticketbooking.service.TicketService;

@RestController //This will be registered to dispatcher servlet and exposed to outside world
@RequestMapping(value = "/tickets")
public class TicketController {
	
	
	//http://localhost:8080/tickets ==> TicketController obj=ioc.getTicketController();
	
	
	/*
	 * 
	 * 
	 * @RestController ==> @Rest + @Controller 
	 * 			@Rest ==> Communicating with FE Framework via REST WEBSERVICE PROTOCOL
	 * 
	 * WEBSERVICE ==> HERTEROGENIOUS SYSTEMS COMMUNICATION
	 * 
	 * Controller ==> FE and Database
	 * 
	 * FE ==> Json Data and it consumed by Back End
	 * Backend produces JSON Data ==> It will be consumed by FE
	 * 
	 * 
	 * @GET ==> Performing GET Operations  ==> @Get + @RequestMapping ==> @GetMapping
	 * @POST ==> Performing Create Operations ==> @Post+ @RequestMapping==> @PostMapping
	 * @PUT ==> Performing Update Operations ==> @Put + @RequestMapping ==> @PutMapping
	 * @Delete ==> Delete Operations ==> @Delete+@RequestMapping==>@DeleteMapping
	 * 
	 * we need to convert java object into JSON Object ==> Marhsalling
	 * FE need to convert JSON Object to JAVA ==> UnMarshalling   ==> JACKSonLibrary 
	 * 
	 * 
	 * TicketService obj=new TicketService();
	 * TicketController obj1=new TicketController();
	 * obj1.setTicketService(obj);
	 * 
	 * 
	 * @RequestBody==>In a webservice request ==> Go to Body section ==> JSON will be there ==> Convert into Java
	 * 
	 */

	@Autowired
	private TicketService ticketService;
	
	
	//Create Ticket
	@PostMapping(value="/create") //http://localhost:8080/tickets/create ==>obj.createTicket()
	public Ticket createTicket(@RequestBody Ticket inputObj) {
		return ticketService.createTicket(inputObj);
		
	}
	
	
	
	
	//Retrieve All Tickets
	@GetMapping(value="/all") //http://localhost:8080/tickets/all
	public Iterable<Ticket> getAllTickets(){
		return ticketService.retrieveTickets();
	}
	
	
	//Retrieve Individual Ticket
	//http://localhost:8080/tickets/1 ==> 1st Ticket
	//http://localhost:8080/tickets/100 ==> 100th Ticket
	//http://localhost:8080/tickets/58 ==> 58th Ticket
	
	@GetMapping(value="/{ticketId}")
	public Ticket getTicket(@PathVariable("ticketId") Integer ticketId) {
		return ticketService.getTicket(ticketId);
	}
	
	//Update Ticket
	
	
	//Delete Ticket
}
