package com.ashokit.ticketbooking.dao;

import org.springframework.data.repository.CrudRepository;
import org.springframework.stereotype.Repository;

import com.ashokit.ticketbooking.model.Ticket;

@Repository
/*
 * 
 * This Annotation will create a database connection if not avilable 
 * If db connection is available ==> It will use the existing Connection
 * 
 * EntityManagerFactory Object will be used to load Database Connection
 * 
 * 
 * Common Operations to any Table
 * C ==> Create ==> Insert the record
 * 
 * R ==> Read ==> Read the Record
 * 
 * U ==> Update ==> Update the Record
 * 
 * D ==> Delete ==> Delete the Record
 * 
 * 
 * CRUDRepository was created on the same purpose
 * 
 *     2 Inputs ==> 1) Model Class Name 2) Datatype of PK
 *     
 */
public interface TicketDao extends CrudRepository<Ticket, Integer>{
	
	/*
	 * 
	 * save ==> Insert or Update
	 * findAll ==> Retrieve all Records
	 * findById ==> Retrieve Specific Record
	 * deleteById ==> Delete Specific Record 
	 *
	 */
	
	
	
	

}
