package com.ashokit.ticketbooking.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ashokit.ticketbooking.dao.TicketDao;
import com.ashokit.ticketbooking.model.Ticket;

//We will write business logic inside the service
@Service //It will automatically instantiate or load all third party dependencies
public class TicketService {
	
	@Autowired
	private TicketDao ticketDao;
	
	
	
	//Create Ticket
	
	public Ticket createTicket(Ticket inputObj) {
		return ticketDao.save(inputObj);
		//save Method internally performs insert Operation
		//if inputobj.getticketid ==null ==> Perform insert operation
	}
	
	
	//Retrieve All Tickets
	
	public Iterable<Ticket> retrieveTickets(){
		return ticketDao.findAll();
		//findAll==> select * from tbl_ticket
		//Result set will converted into Java Class Also
	}
	
	
	//Retrieve Single Ticket
	public Ticket getTicket(Integer ticketId) {
		return ticketDao.findById(ticketId).
				orElse(new Ticket());
		
		//findById ==> select * from tbl_ticket where ticket_id=ticketId
		//Result set will converted to Java Class
	}
	
	
	//Update Ticket
	public Ticket updateTicket(Integer ticketId,String newEmail) {
		//update tbl_ticket set email=newEmail where ticket_id=ticketId
		Ticket dbObj=getTicket(ticketId);
		
		dbObj.setEmail(newEmail);
		
		return ticketDao.save(dbObj); //Here save will perform update , dbObj.getTicketId!=null
		
	}
	
	
	//Delete Ticket
	public void deleteTicket(Integer ticketId) {
		ticketDao.deleteById(ticketId);
		//deleteById ==> delete from tbl_ticket where ticket_id=ticketId
	}

}
