package com.ashokit.helloworld;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;


/*
 * 
 * Bootstrap Class ==> Starting Point of Execution
 * 
 * Every Spring Boot Project should have one bootstrap class only.
 * 
 * A Java Class which is having @SpringBootApplication is called as Bootstrap Class
 * 
 * This will create IOC Container at run time ==> Inversion of Control Container ==> Efficient Memory Management
 * 
 * EmployeeService empService=new EmployeeService(); ==> Traditional way of writing of code
 * 
 * but in Spring ,IOC will take care of object managment==> Creating Object, Managing the state of the Object and destroying the object
 * 
 * Bootstrap Class Functionalities
 * 
 *     1) This will create IOC Container at run time so that all the objects will be managed by IOC
 *     2) This will auto scan the project and the jars ==> It will identify which jar need to be started at run time 
 *                                                         and starts them automatically
 *                                                         
 *                                                         Tomcat need to be started automatically
 *                                                         Database connection to be established automcatically
 *     3) It will create web application context ==> A seperate memory area where all our files will be resided in that area
 *     
 *      Order.java, OrderController.java,OrderService.java,OrderDao.java
 *      
 *      <bean id="ordObj" class="com.ashokit.model.Order" prototype="singleton">
 *      <bean id="ordControler" class="com.ashokit.controller.OrderController" prototype="singleton">
 *      <bean id="ordSerice" class="com.ashokit.service.OrderService" prototype="singleton">
 *      <bean id="ordDao" class="com.ashokit.Dao.OrderDao" prototype="singleton">
 *      
 * 
 * 
 * 
 */
@SpringBootApplication
public class HelloWorldInSpringBootApplication {

	public static void main(String[] args) {
		
		//The below line will scan all the files which are under boostrap package and bootstrap subpacakge and pushes them
		//to web application context
		//com.ashokit.helloworld ==> HelloWorldInSpringBootApplication.java
		
		//Any classes created inside com.ashokit.helloworld and com.ashokit.helloworld.*
		
		/*
		 * 
		 * com.amazon.order.model ==> Where all Model Classes will be created
		 * com.amzon.order.dto ==> All DTO will be created
		 * com.amzon.order.customer ==> All Customer will be created
		 * com.amzon.order.controller ==> All Controller classes will be created
		 * com.amzon.order.service ==> All Service will be created
		 * com.amzon.order.dao ==> All Dao Classes will be create
		 */
		SpringApplication.run(HelloWorldInSpringBootApplication.class, args);
	}

}
