package com.ashokit.collections;



import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;


import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

import com.ashokit.collections.model.Book;
import com.ashokit.collections.model.Person;
import com.ashokit.collections.model.Publisher;
import com.ashokit.collections.service.PersonService;

@SpringBootApplication
public class CollectionsWithCrudRepoApplication implements CommandLineRunner {
	
	@Autowired
	private PersonService personService;
	

	public static void main(String[] args) {
		SpringApplication.run(CollectionsWithCrudRepoApplication.class, args);
	}

	@Override
	public void run(String... args) throws Exception {
		
		//createPersons();
		//getPersonByIds();
		//findByLastNameAndFirstName();
		//findByLastNameOrFirstName();
		//findByLastNameOrderByCreatedDateDesc();
		//findByAgeLessThanEqual();
		//findByFirstNameLike();
		//findByLastNameAndAgeLessThanEqual();
		//findByCreatedDateBetweenwithTime();
		//saveBookPublishers();
		findByBookName();
	}

	
	private void saveBookPublishers() {

		Publisher publisherA = new Publisher("AbdulKalam");
		// insert into tbl_publisher(1,'AbdulKalam');
		Publisher publisherB = new Publisher("Stephen Kovey");
		Publisher publisherC = new Publisher("ChetanBagath");
		Publisher publisherD = new Publisher("Author2");
		Publisher publisherE = new Publisher("Author3");
		Publisher publisherF = new Publisher("Nazir");

		// One Book one Author
		Book bookA = new Book("WingsofFire", new HashSet<>(Arrays.asList(publisherA)));
		// insert into tbl_book(1,'WingsOfFire');
		// insert into book_publishere(1,1);

		Book bookB = new Book("SevenHabits", new HashSet<>(Arrays.asList(publisherB)));
		// insert into tbl_book(2,'SevenHabits');
		// insert into book_publishere(2,2);

		Book bookC = new Book("TwoStates", new HashSet<>(Arrays.asList(publisherC)));
		// insert into tbl_book(3,'TwoStates');
		// insert into book_publishere(3,3);

		// One Book More than one Author
		Book bookD = new Book("Book2", new HashSet<>(Arrays.asList(publisherD, publisherE)));

		// insert into tbl_book(4,'Book2');
		// insert into book_publishere(4,3);
		// insert into book_publishere(4,4);

		// One Author more than one book
		Book bookE = new Book("Book5", new HashSet<>(Arrays.asList(publisherF)));
		Book bookF = new Book("Book6", new HashSet<>(Arrays.asList(publisherF)));

		// insert into tbl_book(5,'Book5');
		// insert into book_publishere(5,5);
		// insert into book_publishere(6,5);

		personService.saveAllBooks(Arrays.asList(bookA, bookB, bookC, bookD, bookE, bookF));

		// bookService.saveBooks(Arrays.asList(bookA, bookB));

		// fetch all publishers
		for (Book book : personService.getAllBooks()) {
			System.out.println(book.toString());
		}

	}
	
	
	
	

	private void findByBookName() {
		// 2025-02-20 19:38:39
		Iterable<Book> booksList = personService.findByBookName("Book2");

		for (Book book : booksList) {
			System.out.println("Person Object" + book.toString());

		}

	}
	
	
	
	private void findByCreatedDateBetweenwithTime() {
		// 2025-02-20 19:38:39
		Iterable<Person> personsList = personService.findByCreatedDateBetween(
				getDatewithTime("2025-02-20 19:38:30"),
				getDatewithTime("2025-02-20 19:38:40"));

		for (Person person : personsList) {
			System.out.println("Person Object" + person.toString());

		}

	}
	
	private Date getDatewithTime(String dateString) {
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

		try {
			return format.parse(dateString);
		} catch (ParseException pe) {
			throw new RuntimeException(pe);
		}
	}
	
	
	private void createPersons() {

		/*
		 * List<Person> personList=new ArrayList<Person>();
		 * 
		 * personList.add(new Person("Kiran", "kumar", "kiran@gmail.com", 20));
		 * 
		 * personList.add(new Person("Kiran1", "kumar", "kiran@gmail.com", 20));
		 * 
		 * personList.add(new Person("Kiran2", "kumar", "kiran@gmail.com", 20));
		 * personList.add(new Person("Kiran3", "kumar", "kiran@gmail.com", 20));
		 * personList.add(new Person("Kiran4", "kumar", "kiran@gmail.com", 20));
		 * personList.add(new Person("Kiran5", "kumar", "kiran@gmail.com", 20));
		 * personList.add(new Person("Kiran6", "kumar", "kiran@gmail.com", 20));
		 * personList.add(new Person("Kiran7", "kumar", "kiran@gmail.com", 20));
		 */

		List<Person> personList = Arrays.asList(
				new Person("Kiran", "kumar", "kiran@gmail.com", 20),
				new Person("Ram", "kumar", "ram@gmail.com", 22),
				new Person("RamKiran", "LaxmiKiran", "sita@gmail.com", 30),
				new Person("Lakshamn", "Seth", "seth@gmail.com", 50),
				new Person("Sita", "Kumar", "lakshman@gmail.com", 50),
				new Person("Ganesh", "Kumar", "ganesh@gmail.com", 50),
				new Person("KiranKiran", "kumar", "kirannew@gmail.com", 20),
				new Person("RamRam", "kumar", "ramnew@gmail.com", 22),
				new Person("RamKiranRamKiran", "LaxmiKiran", "sitanew@gmail.com", 30),
				new Person("RamKiranRamKiran", "Seth", "sethnee@gmail.com", 50),
				new Person("SitaSita", "Kumar", "lakshmannew@gmail.com", 50),
				new Person("GaneshSita", "Kumar", "ganeshnew@gmail.com", 50));

		Iterable<Person> list = personService.saveAllPersons(personList);
		for (Person person : list) {
			System.out.println("Person Object" + person.toString());

		}
	}
	
	
	private void getPersonByIds() {
		List<Integer> personList = new ArrayList<Integer>();
		personList.add(1);
		personList.add(2);
		personList.add(12);
		personList.add(5);
		personList.add(6);
		personList.add(20);
		personList.add(40);
		personList.add(11);
		personList.add(15);
		personList.add(3);
		personList.add(4);
		Iterable<Person> personsList = personService.findPersons(personList);
		//select * from tbl_person where person_id in (1,2,12,5,6,20,40,11,15,3,4);
		for (Person person : personsList) {
			System.out.println("Person Object" + person.toString());

		}
	}
	
	
	private void findByLastNameAndFirstName() {
		Person person = personService.findByLastNameAndFirstName("kumar", "Ram");
		System.out.println("Person Object" + person.toString());

	}

	private void findByLastNameOrFirstName() {
		Iterable<Person> personsList = personService.findByLastNameOrFirstName("kumar", "Sita");

		for (Person person : personsList) {
			System.out.println("Person Object" + person.toString());

		}

	}
	
	private void findByLastNameOrderByCreatedDateDesc() {
		Iterable<Person> personsList = personService.findByLastNameOrderByCreatedDateDesc("kumar");

		for (Person person : personsList) {
			System.out.println("Person Object" + person.toString());

		}

	}
	
	//findByAgeLessThanEqual
	
	private void findByAgeLessThanEqual() {
		Iterable<Person> personsList = personService.findByAgeLessThanEqual(40);

		for (Person person : personsList) {
			System.out.println("Person Object" + person.toString());

		}

	}
	//findByFirstNameLike
	
	private void findByFirstNameLike() {
		Iterable<Person> personsList = personService.findByFirstNameLike("%Kiran%");

		for (Person person : personsList) {
			System.out.println("Person Object" + person.toString());

		}

	}
	//findByLastNameAndAgeLessThanEqual
	
	private void findByLastNameAndAgeLessThanEqual() {
		Iterable<Person> personsList = personService.findByLastNameAndAgeLessThanEqual("kumar",40);

		for (Person person : personsList) {
			System.out.println("Person Object" + person.toString());

		}

	}
	
}
