package com.ashokit.collections.dao;

import java.util.Date;
import java.util.List;

import org.springframework.data.repository.CrudRepository;
import org.springframework.stereotype.Repository;

import com.ashokit.collections.model.Person;

@Repository
public interface PersonDao extends CrudRepository<Person, Integer> {
	//SaveAll and FindAllById already available in CRUDRepository itself 
	//so we no need to write the code
	
	//Derived Queries
	
	public Person findByLastNameAndFirstName(String lastName,String firstName);
	//select * from tbl_person where last_name=lastName and first_name=lastName
	//The above query should result only one record ==> If it retrieves more than one record it will fail
	//Order is imporant and the same order database will take inputs
	
	
	public Iterable<Person> findByLastNameOrFirstName(String lastName,String firstName);
	//select * from tbl_person where last_name=lastName or first_name=firstName
	
	
	public List<Person> findByLastNameOrderByCreatedDateDesc(String lastName);
	//select * from tbl_person where last_name=lastName order by created_date desc;

	
	public List<Person> findByAgeLessThanEqual(Integer age);
	//select * from tbl_person where age<=age;
	
	
	public List<Person> findByFirstNameLike(String firstName);
	//select * from tbl_person where first_name like '%firstname%';
	
	public List<Person> findByLastNameAndAgeLessThanEqual(String lastName,int age);
	//select * from tbl_person where last_name=lastName and age<=age;
	
	public List<Person> findByCreatedDateBetween(Date startdate,Date endDate);
	//select * from tbl_person where created_date>=startdate and created_date<=endDate
	
	
	
	
	
	
}
