package com.ashokit.collections.service;

import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ashokit.collections.dao.BookDao;
import com.ashokit.collections.dao.PersonDao;
import com.ashokit.collections.model.Book;
import com.ashokit.collections.model.Person;

@Service
public class PersonService {
	
	@Autowired
	private PersonDao personDao;
	
	
	@Autowired
	private BookDao bookDao;
	
	//SaveAll
	

	
	public Iterable<Book> saveAllBooks(Iterable<Book> books){
		return bookDao.saveAll(books);
	}
	
	public Iterable<Book> getAllBooks(){
		return bookDao.findAll();
	}
	
	public Iterable<Person> saveAllPersons(Iterable<Person> personsList){
		return personDao.saveAll(personsList);
	}
	
	public Iterable<Book> findByBookName(String bookName)
	{
		return bookDao.findByBookName(bookName);
	}
	//FindAllById
	
	public Iterable<Person> findPersons(List<Integer> personIds){
		return personDao.findAllById(personIds);
	}
	
	
	//Derived Queries Implementation
	public Person findByLastNameAndFirstName(String lastName,String firstName) {
		return personDao.findByLastNameAndFirstName(lastName,firstName);
	}
	
	public Iterable<Person> findByLastNameOrFirstName(String lastName,String firstName){
		return personDao.findByLastNameOrFirstName(lastName, firstName);
	}
	
	public List<Person> findByLastNameOrderByCreatedDateDesc(String lastName){
		return personDao.findByLastNameOrderByCreatedDateDesc(lastName);
	}
	
	public List<Person> findByAgeLessThanEqual(Integer age){
		return personDao.findByAgeLessThanEqual(age);
	}

	public List<Person> findByFirstNameLike(String firstName){
		return personDao.findByFirstNameLike(firstName);
	}
	
	public List<Person> findByLastNameAndAgeLessThanEqual(String lastName,int age){
		return personDao.findByLastNameAndAgeLessThanEqual(lastName, age);
	}
	
	public List<Person> findByCreatedDateBetween(Date startdate,Date endDate){
		return personDao.findByCreatedDateBetween(startdate, endDate);
	}
	
	
}
