package com.ashokit.collections.model;


import java.util.Set;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Table;

@Entity
@Table(name = "tbl_publisher")
public class Publisher {
	
	
	@Id
	@GeneratedValue(strategy = GenerationType.AUTO)
	@Column(name  ="pub_id")
	private Integer pubId;
	
	
	@Column(name="pub_name")
	private String pubName;
	
	@ManyToMany(cascade = CascadeType.ALL,mappedBy = "publishers")
	private Set<Book> books;

	public Integer getPubId() {
		return pubId;
	}

	public void setPubId(Integer pubId) {
		this.pubId = pubId;
	}

	public String getPubName() {
		return pubName;
	}

	public void setPubName(String pubName) {
		this.pubName = pubName;
	}

	public Set<Book> getBooks() {
		return books;
	}

	public void setBooks(Set<Book> books) {
		this.books = books;
	}

	public Publisher(String pubName) {
		super();
		this.pubName = pubName;
	}
	
	public Publisher() {}
	
	@Override
	public String toString() {
		String result = String.format
				("Publisher [id=%d, name='%s']%n", pubId, pubName);
		if (books != null) {
			for (Book book : books) {
				result += String.format("Book[id=%d, name='%s']%n", book.getBookId(),
						book.getBookName());
			}
		}

		return result;
	}
	
	

}

